using MicroFour.StrataFrame.Business;
using MicroFour.StrataFrame.Security;
using MicroFour.StrataFrame.UI.Windows.Forms;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.IO;

namespace StrataFlix.Business
{
    public partial class MovieImagesBO
    {

        #region " Component Implementation "

        [System.Diagnostics.DebuggerNonUserCodeAttribute()]
        protected override void Dispose(bool disposing)
        {
            if (disposing && (this.components != null))
            {
                this.components.Dispose();
            }
            base.Dispose(disposing);
        }

        private System.ComponentModel.Container components = null;

        //NOTE: The following procedure is required by the Component Designer
        //It can be modified using the Component Designer.
        //Do not modify it using the code editor.
        [System.Diagnostics.DebuggerNonUserCodeAttribute()]
        private void InitializeComponent()
        {
            MicroFour.StrataFrame.Business.BusinessParentRelationship BusinessParentRelationship1 = new MicroFour.StrataFrame.Business.BusinessParentRelationship();
            //
            //MovieImagesBO
            //
            BusinessParentRelationship1.ForeignKeyField = new string[] { "mi_mv_pk" };
            BusinessParentRelationship1.ParentBusinessObjectType = "StrataFlix.Business.MoviesBO";
            BusinessParentRelationship1.ParentPrimaryKeyField = new string[] { "mv_pk" };
            this.ParentRelationship = BusinessParentRelationship1;

        }

        #endregion


        #region BusinessLayer Overriden Methods & Properties

        /// <summary>
        /// The collection of required fields for the business object.
        /// </summary>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override RequiredFieldsCollection RequiredFields
        {
            get
            {
                return base.RequiredFields;
            }
            set
            {
                base.RequiredFields = value;
            }
        }

        /// <summary>
        /// Defines the constraint that defines the parent-child relationship between this business object type and another business object type.
        /// </summary>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override IBusinessParentRelationship ParentRelationship
        {
            get
            {
                return base.ParentRelationship;
            }
            set
            {
                base.ParentRelationship = value;
            }
        }

        /// <summary>
        /// Returns all of the field names in a single string in the form of [field1],[field2],...  This must be used in the place of '*' in select statements if Query Notifications are to be registered.
        /// </summary>
        protected override String AllFieldNames
        {
            get
            {
                return "[mi_pk],[mi_mv_pk],[mi_ImageData],[mi_CreatedAt],[mi_CreatedBy],[mi_Version]";
            }
        }

        /// <summary>
        /// The name of the database that contains the table to which this business object is mapped.
        /// </summary>
        public override String Database
        {
            get
            {
                return "StrataFlix";
            }
        }

        private static string[] _PrimaryKeyFields = new string[] { "mi_pk" };
        /// <summary>
        /// Gets the field or fields that comprise the primary key for the business object.
        /// </summary>
        public override string[] PrimaryKeyFields
        {
            get
            {
                return _PrimaryKeyFields;
            }
        }

        /// <summary>
        /// The name of the table in the database to which this business object is mapped.
        /// </summary>
        public override String TableName
        {
            get
            {
                return "MovieImages";
            }
        }

        /// <summary>
        /// The schema of the table in the database to which this business object is mapped.
        /// </summary>
        public override String TableSchema
        {
            get
            {
                return "dbo";
            }
        }

        /// <summary>
        /// Creates and returns an array of DataColumns that contains the schema for the table.  This is used to prevent a round trip to the server to aquire the initial schema for the internal DataTable.
        /// </summary>
        protected override DataColumn[] CreateTableSchema()
        {
            return new DataColumn[] {
new DataColumn("mi_pk", typeof(System.Int32)),
new DataColumn("mi_mv_pk", typeof(System.Int32)),
new DataColumn("mi_ImageData", typeof(System.Byte[])),
new DataColumn("mi_CreatedAt", typeof(System.DateTime)),
new DataColumn("mi_CreatedBy", typeof(System.Int32)),
new DataColumn("mi_Version", typeof(System.Int32))};
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        protected void AddBrokenRule(MovieImagesBOFieldNames Field, string ErrorMessage)
        {
            base.AddBrokenRule(Field, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        protected new void AddBrokenRule(string FieldName, string ErrorMessage)
        {
            base.AddBrokenRule(FieldName, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        protected void AddBrokenRuleByKey(MovieImagesBOFieldNames Field, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(Field, ErrorMessageKey);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        protected new void AddBrokenRuleByKey(string FieldName, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(FieldName, ErrorMessageKey);
        }

        /// <summary>
        /// Gets a collection of the names for all fields that belong to this business object and map to the database.
        /// </summary>
        public override List<string> AllFieldsList
        {
            get
            {
                return _AllFieldsList;
            }
        }

        /// <summary>
        /// Gets a dictionary of the DbTypes for all fields that belong to this business object and map to the database.
        /// </summary>
        public override Dictionary<string, DbType> FieldDbTypes
        {
            get
            {
                return _FieldDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of all fields within this business object that map to the FieldNames enumeration for this business object.
        /// </summary>
        public override BusinessLayerFieldEnumDictionary FieldEnums
        {
            get
            {
                return _FieldEnums;
            }
        }

        /// <summary>
        /// Gets a dictionary of all of the lengths for all fields within this business object that map to a field in the database.
        /// </summary>
        public override Dictionary<string, int> FieldLengths
        {
            get
            {
                return _FieldLengths;
            }
        }

        /// <summary>
        /// Gets a dictionary of the native DbType (SqlDbType, OracleType, OleDbType, etc.) for all fields within this buisness object that map to a field in the database.
        /// </summary>
        public override Dictionary<string, int> FieldNativeDbTypes
        {
            get
            {
                return _FieldNativeDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of the security permission keys for each field in the business object.
        /// </summary>
        public override Dictionary<string, string> FieldPermissionKeys
        {
            get
            {
                return _FieldPermissionKeys;
            }
        }

        #endregion

        #region Field Properties

        /// <summary>
        /// Primary Key
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Primary Key"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 mi_pk
        {
            get
            {
                return (System.Int32)this.CurrentRow["mi_pk"];
            }
            set
            {
                this.CurrentRow["mi_pk"] = value;
            }
        }

        /// <summary>
        /// Movie Foreign Key
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Movie Foreign Key"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 mi_mv_pk
        {
            get
            {
                return (System.Int32)this.CurrentRow["mi_mv_pk"];
            }
            set
            {
                this.CurrentRow["mi_mv_pk"] = value;
            }
        }

        /// <summary>
        /// Image Data
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Image Data"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Byte[] mi_ImageData
        {
            get
            {
                return (System.Byte[])this.CurrentRow["mi_ImageData"];
            }
            set
            {
                this.CurrentRow["mi_ImageData"] = value;
            }
        }

        /// <summary>
        /// Time Stamp
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Time Stamp"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.DateTime mi_CreatedAt
        {
            get
            {
                return (System.DateTime)this.CurrentRow["mi_CreatedAt"];
            }
            set
            {
                this.CurrentRow["mi_CreatedAt"] = value;
            }
        }

        /// <summary>
        /// User Stamp
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("User Stamp"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 mi_CreatedBy
        {
            get
            {
                return (System.Int32)this.CurrentRow["mi_CreatedBy"];
            }
            set
            {
                this.CurrentRow["mi_CreatedBy"] = value;
            }
        }

        /// <summary>
        /// Row Version
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Row Version"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 mi_Version
        {
            get
            {
                return (System.Int32)this.CurrentRow["mi_Version"];
            }
            set
            {
                this.CurrentRow["mi_Version"] = value;
            }
        }

        #endregion

        #region Field Property Events

        #endregion

        #region Nested Types & Field Security

        /// <summary>
        /// Contains all of the field names that belong to the business object.
        /// </summary>
        public enum MovieImagesBOFieldNames
        {
            mi_pk,
            mi_mv_pk,
            mi_ImageData,
            mi_CreatedAt,
            mi_CreatedBy,
            mi_Version,
            CUSTOM_FIELD
        }

        /// <summary>
        /// Gets the System.Type of the enumeration that contains the field names for the business object.
        /// </summary>
        public override System.Type GetFieldEnumType()
        {
            return typeof(MovieImagesBOFieldNames);
        }

        /// <summary>
        /// Creates a new CheckFieldSecurityEventArgs object that can be used with this business object type.
        /// </summary>
        protected override CheckFieldSecurityEventArgsBase CreateNewFieldSecurityEventArgs(System.Enum Field, string CustomField, string PermissionKey, PermissionInfo Perm)
        {
            return new CheckFieldSecurityEventArgs<MovieImagesBOFieldNames>(Field, CustomField, PermissionKey, Perm);
        }

        /// <summary>
        /// Describes a method that will handle the CheckFieldScurity event.
        /// </summary>
        public delegate void CheckFieldSecurityEventHandler(object sender, CheckFieldSecurityEventArgs<MovieImagesBOFieldNames> e);

        /// <summary>
        /// Occurs when the business objects needs to check the security on a field.
        /// </summary>
        public event CheckFieldSecurityEventHandler CheckFieldSecurity;

        /// <summary>
        /// Raises the CheckFieldSecurity event.
        /// </summary>
        protected override void OnCheckFieldSecurity(CheckFieldSecurityEventArgsBase e)
        {
            if (this.CheckFieldSecurity != null)
            {
                this.CheckFieldSecurity(this, (CheckFieldSecurityEventArgs<MovieImagesBOFieldNames>)e);
            }
        }

        #endregion

        #region Item Property Implementation


        private static List<string> _AllFieldsList;
        private static Dictionary<string, DbType> _FieldDbTypes;
        private static BusinessLayerFieldEnumDictionary _FieldEnums;
        private static Dictionary<string, int> _FieldLengths;
        private static Dictionary<string, int> _FieldNativeDbTypes;
        private static Dictionary<string, string> _FieldPermissionKeys;

        /// <summary>
        /// Initializes the static members of the MovieImagesBO class.
        /// </summary>
        static MovieImagesBO()
        {
            //-- Create the new shared dictionary and populate it with an 
            //   instance of each property descriptor
            _PropertyDescriptors = new PropertyDescriptorDictionary(11);
            _PropertyDescriptors.Add("mi_pk", new FieldDescriptor(MovieImagesBOFieldNames.mi_pk, typeof(System.Int32)));
            _PropertyDescriptors.Add("mi_mv_pk", new FieldDescriptor(MovieImagesBOFieldNames.mi_mv_pk, typeof(System.Int32)));
            _PropertyDescriptors.Add("mi_ImageData", new FieldDescriptor(MovieImagesBOFieldNames.mi_ImageData, typeof(System.Byte[])));
            _PropertyDescriptors.Add("mi_CreatedAt", new FieldDescriptor(MovieImagesBOFieldNames.mi_CreatedAt, typeof(System.DateTime)));
            _PropertyDescriptors.Add("mi_CreatedBy", new FieldDescriptor(MovieImagesBOFieldNames.mi_CreatedBy, typeof(System.Int32)));
            _PropertyDescriptors.Add("mi_Version", new FieldDescriptor(MovieImagesBOFieldNames.mi_Version, typeof(System.Int32)));

            _AllFieldsList = new List<string>(6);
            _AllFieldsList.Add("mi_pk");
            _AllFieldsList.Add("mi_mv_pk");
            _AllFieldsList.Add("mi_ImageData");
            _AllFieldsList.Add("mi_CreatedAt");
            _AllFieldsList.Add("mi_CreatedBy");
            _AllFieldsList.Add("mi_Version");

            _FieldDbTypes = new Dictionary<string, DbType>(6);
            _FieldDbTypes.Add("mi_pk", DbType.Int32);
            _FieldDbTypes.Add("mi_mv_pk", DbType.Int32);
            _FieldDbTypes.Add("mi_ImageData", DbType.Binary);
            _FieldDbTypes.Add("mi_CreatedAt", DbType.DateTime);
            _FieldDbTypes.Add("mi_CreatedBy", DbType.Int32);
            _FieldDbTypes.Add("mi_Version", DbType.Int32);

            _FieldEnums = new BusinessLayerFieldEnumDictionary(7);
            _FieldEnums.Add("mi_pk", MovieImagesBOFieldNames.mi_pk);
            _FieldEnums.Add("mi_mv_pk", MovieImagesBOFieldNames.mi_mv_pk);
            _FieldEnums.Add("mi_ImageData", MovieImagesBOFieldNames.mi_ImageData);
            _FieldEnums.Add("mi_CreatedAt", MovieImagesBOFieldNames.mi_CreatedAt);
            _FieldEnums.Add("mi_CreatedBy", MovieImagesBOFieldNames.mi_CreatedBy);
            _FieldEnums.Add("mi_Version", MovieImagesBOFieldNames.mi_Version);
            _FieldEnums.Add("CUSTOM_FIELD", MovieImagesBOFieldNames.CUSTOM_FIELD);

            _FieldLengths = new Dictionary<string, int>(6);
            _FieldLengths.Add("mi_pk", 4);
            _FieldLengths.Add("mi_mv_pk", 4);
            _FieldLengths.Add("mi_ImageData", -1);
            _FieldLengths.Add("mi_CreatedAt", 8);
            _FieldLengths.Add("mi_CreatedBy", 4);
            _FieldLengths.Add("mi_Version", 4);

            _FieldNativeDbTypes = new Dictionary<string, int>(6);
            _FieldNativeDbTypes.Add("mi_pk", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("mi_mv_pk", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("mi_ImageData", (int)System.Data.SqlDbType.VarBinary);
            _FieldNativeDbTypes.Add("mi_CreatedAt", (int)System.Data.SqlDbType.DateTime);
            _FieldNativeDbTypes.Add("mi_CreatedBy", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("mi_Version", (int)System.Data.SqlDbType.Int);

            _FieldPermissionKeys = new Dictionary<string, string>(6);

        }

        private static bool _AreCustomDescriptorsEvaluated = false;
        protected override bool AreCustomDescriptorsEvaluated
        {
            get
            {
                bool llReturn = _AreCustomDescriptorsEvaluated;
                _AreCustomDescriptorsEvaluated = true;
                return llReturn;
            }
        }

        private static PropertyDescriptorDictionary _PropertyDescriptors;
        protected override PropertyDescriptorDictionary PropertyDescriptors
        {
            get
            {
                return _PropertyDescriptors;
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of fields within the MovieImagesBO business object.
        /// </summary>
        private class FieldDescriptor :
        MicroFour.StrataFrame.Business.FieldPropertyDescriptor<MovieImagesBOFieldNames>
        {
            public FieldDescriptor(MovieImagesBOFieldNames field, Type fieldType) :
                base(field, fieldType) { }
            private static Type _ComponentType = typeof(MovieImagesBO);
            public override object GetValue(object component)
            {
                switch (this.Field)
                {
                    case MovieImagesBOFieldNames.mi_pk:
                        return ((MovieImagesBO)component).mi_pk;
                    case MovieImagesBOFieldNames.mi_mv_pk:
                        return ((MovieImagesBO)component).mi_mv_pk;
                    case MovieImagesBOFieldNames.mi_ImageData:
                        return ((MovieImagesBO)component).mi_ImageData;
                    case MovieImagesBOFieldNames.mi_CreatedAt:
                        return ((MovieImagesBO)component).mi_CreatedAt;
                    case MovieImagesBOFieldNames.mi_CreatedBy:
                        return ((MovieImagesBO)component).mi_CreatedBy;
                    case MovieImagesBOFieldNames.mi_Version:
                        return ((MovieImagesBO)component).mi_Version;
                    default:
                        throw new BusinessLayerException("Field not supported.");
                }
            }
            public override void SetValue(object component, object value)
            {
                switch (this.Field)
                {
                    case MovieImagesBOFieldNames.mi_pk:
                        ((MovieImagesBO)component).mi_pk = (System.Int32)value;
                        break;
                    case MovieImagesBOFieldNames.mi_mv_pk:
                        ((MovieImagesBO)component).mi_mv_pk = (System.Int32)value;
                        break;
                    case MovieImagesBOFieldNames.mi_ImageData:
                        ((MovieImagesBO)component).mi_ImageData = (System.Byte[])value;
                        break;
                    case MovieImagesBOFieldNames.mi_CreatedAt:
                        ((MovieImagesBO)component).mi_CreatedAt = (System.DateTime)value;
                        break;
                    case MovieImagesBOFieldNames.mi_CreatedBy:
                        ((MovieImagesBO)component).mi_CreatedBy = (System.Int32)value;
                        break;
                    case MovieImagesBOFieldNames.mi_Version:
                        ((MovieImagesBO)component).mi_Version = (System.Int32)value;
                        break;
                    default:
                        throw new BusinessLayerException("Field not supported.");
                }
            }
            public override Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        #endregion

    }

}
